<?php
/**
 * Plugin Name: Advanced Fixed Call Button
 * Description: دکمه تماس ثابت با تنظیمات حرفه‌ای شامل شماره، رنگ، افکت، موقعیت، اندازه متن و پنل مدیریت کامل.
 * Version: 3.0
 * Author: سعید  راد
 */

if (!defined('ABSPATH')) exit;

// منو در پنل مدیریت
function afcb_add_admin_menu() {
    add_menu_page('دکمه تماس ثابت', 'دکمه تماس ثابت', 'manage_options', 'afcb_settings', 'afcb_settings_page', 'dashicons-phone', 80);
}
add_action('admin_menu', 'afcb_add_admin_menu');

// لینک تنظیمات در صفحه افزونه‌ها
function afcb_plugin_action_links($links) {
    $settings_link = '<a href="admin.php?page=afcb_settings">تنظیمات</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'afcb_plugin_action_links');

// ثبت تنظیمات
function afcb_settings_init() {
    register_setting('afcb_plugin', 'afcb_settings');

    add_settings_section('afcb_section', 'تنظیمات اصلی', null, 'afcb_settings');

    add_settings_field('afcb_phone', 'شماره تماس', 'afcb_phone_render', 'afcb_settings', 'afcb_section');
    add_settings_field('afcb_bg_color', 'رنگ پس‌زمینه', 'afcb_bg_color_render', 'afcb_settings', 'afcb_section');
    add_settings_field('afcb_text_color', 'رنگ متن', 'afcb_text_color_render', 'afcb_settings', 'afcb_section');
    add_settings_field('afcb_font_size', 'سایز نوشته', 'afcb_font_size_render', 'afcb_settings', 'afcb_section');
    add_settings_field('afcb_effect', 'افکت نمایشی', 'afcb_effect_render', 'afcb_settings', 'afcb_section');
    add_settings_field('afcb_position', 'موقعیت نمایش دکمه', 'afcb_position_render', 'afcb_settings', 'afcb_section');
}
add_action('admin_init', 'afcb_settings_init');

// فیلدهای تنظیمات
function afcb_phone_render() {
    $options = get_option('afcb_settings');
    echo "<input type='text' name='afcb_settings[afcb_phone]' value='" . esc_attr($options['afcb_phone'] ?? '') . "'>";
}
function afcb_bg_color_render() {
    $options = get_option('afcb_settings');
    echo "<input type='color' name='afcb_settings[afcb_bg_color]' value='" . esc_attr($options['afcb_bg_color'] ?? '#001f3f') . "'>";
}
function afcb_text_color_render() {
    $options = get_option('afcb_settings');
    echo "<input type='color' name='afcb_settings[afcb_text_color]' value='" . esc_attr($options['afcb_text_color'] ?? '#FFD700') . "'>";
}
function afcb_font_size_render() {
    $options = get_option('afcb_settings');
    $selected = $options['afcb_font_size'] ?? '16';
    echo "<select name='afcb_settings[afcb_font_size]'>
        <option value='12' " . selected($selected, '12', false) . ">12px</option>
        <option value='14' " . selected($selected, '14', false) . ">14px</option>
        <option value='16' " . selected($selected, '16', false) . ">16px (پیش‌فرض)</option>
        <option value='18' " . selected($selected, '18', false) . ">18px</option>
        <option value='20' " . selected($selected, '20', false) . ">20px</option>
    </select>";
}
function afcb_effect_render() {
    $options = get_option('afcb_settings');
    $selected = $options['afcb_effect'] ?? 'none';
    echo "<select name='afcb_settings[afcb_effect]'>
        <option value='none' " . selected($selected, 'none', false) . ">بدون افکت</option>
        <option value='shake' " . selected($selected, 'shake', false) . ">لرزش</option>
        <option value='bounce' " . selected($selected, 'bounce', false) . ">پرش</option>
        <option value='pulse' " . selected($selected, 'pulse', false) . ">ضربان</option>
    </select>";
}
function afcb_position_render() {
    $options = get_option('afcb_settings');
    $selected = $options['afcb_position'] ?? 'bottom-right';
    echo "<select name='afcb_settings[afcb_position]'>
        <option value='top-left' " . selected($selected, 'top-left', false) . ">بالا چپ</option>
        <option value='top-center' " . selected($selected, 'top-center', false) . ">بالا وسط</option>
        <option value='top-right' " . selected($selected, 'top-right', false) . ">بالا راست</option>
        <option value='bottom-left' " . selected($selected, 'bottom-left', false) . ">پایین چپ</option>
        <option value='bottom-center' " . selected($selected, 'bottom-center', false) . ">پایین وسط</option>
        <option value='bottom-right' " . selected($selected, 'bottom-right', false) . ">پایین راست</option>
    </select>";
}

// صفحه تنظیمات
function afcb_settings_page() {
    ?>
    <div class="wrap">
        <h1>تنظیمات دکمه تماس ثابت</h1>
        <form action='options.php' method='post'>
            <?php
            settings_fields('afcb_plugin');
            do_settings_sections('afcb_settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

// استایل و دکمه در سایت
function afcb_enqueue_button() {
    $options = get_option('afcb_settings');
    $phone = $options['afcb_phone'] ?? '';
    if (!$phone) return;

    $bg = $options['afcb_bg_color'] ?? '#001f3f';
    $color = $options['afcb_text_color'] ?? '#FFD700';
    $effect = $options['afcb_effect'] ?? 'none';
    $position = $options['afcb_position'] ?? 'bottom-right';
    $font_size = $options['afcb_font_size'] ?? '16';

    $effect_css = '';
    if ($effect == 'shake') {
        $effect_css = '@keyframes afcb_anim { 0%,100%{transform:translate(0)} 20%{transform:translate(-2px)} 40%{transform:translate(2px)} 60%{transform:translate(-2px)} 80%{transform:translate(2px)} }';
    } elseif ($effect == 'bounce') {
        $effect_css = '@keyframes afcb_anim { 0%,100%{transform:translateY(0)} 50%{transform:translateY(-10px)} }';
    } elseif ($effect == 'pulse') {
        $effect_css = '@keyframes afcb_anim { 0%{transform:scale(1)} 50%{transform:scale(1.1)} 100%{transform:scale(1)} }';
    }

    $position_css = "bottom:20px;right:20px;";
    if ($position == 'bottom-left') $position_css = "bottom:20px;left:20px;";
    elseif ($position == 'bottom-center') $position_css = "bottom:20px;left:50%;transform:translateX(-50%);";
    elseif ($position == 'top-left') $position_css = "top:20px;left:20px;";
    elseif ($position == 'top-right') $position_css = "top:20px;right:20px;";
    elseif ($position == 'top-center') $position_css = "top:20px;left:50%;transform:translateX(-50%);";

    echo "<style>
        #afcb-fixed-call {
            position: fixed;
            {$position_css}
            z-index: 9999;
            background-color: {$bg};
            color: {$color};
            border-radius: 50px;
            padding: 12px 20px;
            font-size: {$font_size}px;
            font-weight: bold;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            transition: transform 0.3s ease;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: afcb_anim 2s infinite;
        }
        @media (max-width:768px){
            #afcb-fixed-call {
                font-size: {$font_size}px;
                padding: 10px 16px;
            }
        }
        {$effect_css}
    </style>";
    echo "<a href='tel:{$phone}' id='afcb-fixed-call'>📞 تماس با ما: <i>{$phone}</i></a>";
}
add_action('wp_footer', 'afcb_enqueue_button');
?>
