<?php
/**
 * Plugin Name: WooCommerce Category Description Order
 * Description: تنظیم ترتیب نمایش عنوان دسته‌بندی، توضیحات دسته‌بندی و محصولات در صفحه دسته‌بندی ووکامرس با پنل تنظیمات.
 * Version: 1.1
 * Author: سعید راد
 * Author URI: https://example.com
 * Text Domain: wc-category-desc-order
 * 
 * تیم توسعه: تیم سئو کندو
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // جلوگیری از دسترسی مستقیم
}

class WC_Category_Description_Order {

    public function __construct() {
        add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
        add_action( 'admin_init', array( $this, 'settings_init' ) );

        add_action( 'wp', array( $this, 'maybe_modify_output_order' ) );
    }

    public function add_admin_menu() {
        add_options_page(
            'Woo Category Description Order',
            'Category Description Order',
            'manage_options',
            'wc_category_description_order',
            array( $this, 'options_page' )
        );
    }

    public function settings_init() {
        register_setting( 'wc_category_desc_order_group', 'wc_category_desc_order_setting' );
        register_setting( 'wc_category_desc_order_group', 'wc_category_title_position' );

        add_settings_section(
            'wc_category_desc_order_section',
            __('تنظیمات ترتیب نمایش', 'wc-category-desc-order'),
            null,
            'wc_category_description_order'
        );

        add_settings_field(
            'wc_category_desc_order_field',
            __('ترتیب نمایش توضیحات دسته‌بندی و محصولات', 'wc-category-desc-order'),
            array( $this, 'settings_field_render' ),
            'wc_category_description_order',
            'wc_category_desc_order_section'
        );

        add_settings_field(
            'wc_category_title_position_field',
            __('محل نمایش عنوان دسته‌بندی', 'wc-category-desc-order'),
            array( $this, 'title_position_field_render' ),
            'wc_category_description_order',
            'wc_category_desc_order_section'
        );
    }

    public function settings_field_render() {
        $option = get_option( 'wc_category_desc_order_setting', 'desc_first' );
        ?>
        <select name="wc_category_desc_order_setting" id="wc_category_desc_order_setting">
            <option value="desc_first" <?php selected( $option, 'desc_first' ); ?>><?php _e('توضیحات دسته‌بندی اول، محصولات بعد', 'wc-category-desc-order'); ?></option>
            <option value="products_first" <?php selected( $option, 'products_first' ); ?>><?php _e('محصولات اول، توضیحات دسته‌بندی بعد', 'wc-category-desc-order'); ?></option>
        </select>
        <?php
    }

    public function title_position_field_render() {
        $option = get_option( 'wc_category_title_position', 'before_products' );
        ?>
        <select name="wc_category_title_position" id="wc_category_title_position">
            <option value="before_products" <?php selected( $option, 'before_products' ); ?>><?php _e('عنوان دسته‌بندی قبل از محصولات', 'wc-category-desc-order'); ?></option>
            <option value="after_products" <?php selected( $option, 'after_products' ); ?>><?php _e('عنوان دسته‌بندی بعد از محصولات و قبل از توضیحات', 'wc-category-desc-order'); ?></option>
            <option value="hide" <?php selected( $option, 'hide' ); ?>><?php _e('عدم نمایش عنوان دسته‌بندی', 'wc-category-desc-order'); ?></option>
        </select>
        <?php
    }

    public function options_page() {
        ?>
        <div class="wrap">
            <h1><?php esc_html_e('تنظیم ترتیب نمایش توضیحات دسته‌بندی ووکامرس', 'wc-category-desc-order'); ?></h1>
            <form action="options.php" method="post">
                <?php
                settings_fields( 'wc_category_desc_order_group' );
                do_settings_sections( 'wc_category_description_order' );
                submit_button();
                ?>
            </form>
            <p><em>توسعه توسط تیم سئو کندو</em></p>
        </div>
        <?php
    }

    public function maybe_modify_output_order() {
        if ( ! is_tax( 'product_cat' ) && ! is_post_type_archive( 'product' ) ) {
            return;
        }

        $desc_order = get_option( 'wc_category_desc_order_setting', 'desc_first' );
        $title_position = get_option( 'wc_category_title_position', 'before_products' );

        // اول حذف همه اکشن‌های پیش‌فرض مربوط به عنوان و توضیحات دسته‌بندی
        remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
        remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description', 10 );
        remove_action( 'woocommerce_before_main_content', 'woocommerce_template_loop_category_title', 10 );
        remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

        // حذف عنوان پیش‌فرض (که عموماً در قالب‌ها متفاوته، پس خودمون اضافه می‌کنیم)
        // اضافه کردن مجدد عنوان دسته‌بندی طبق تنظیمات

        // ابتدا حذف نمایش عنوان پیش‌فرض
        remove_action( 'woocommerce_before_main_content', 'woocommerce_template_loop_category_title', 10 );

        // نمایش عنوان طبق انتخاب
        switch ( $title_position ) {
            case 'before_products':
                add_action( 'woocommerce_archive_description', array( $this, 'display_category_title' ), 5 );
                break;
            case 'after_products':
                add_action( 'woocommerce_after_shop_loop', array( $this, 'display_category_title' ), 4 ); // قبل از توضیحات دسته‌بندی که 5 است
                break;
            case 'hide':
                // نمایش داده نشود
                break;
        }

        // تنظیم ترتیب نمایش توضیحات و محصولات
        if ( $desc_order === 'products_first' ) {
            // محصولات اول، توضیحات بعد
            remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
            add_action( 'woocommerce_after_shop_loop', 'woocommerce_taxonomy_archive_description', 5 );
        } else {
            // توضیحات اول، محصولات بعد
            remove_action( 'woocommerce_after_shop_loop', 'woocommerce_taxonomy_archive_description', 5 );
            add_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
        }
    }

    // تابع نمایش عنوان دسته‌بندی
    public function display_category_title() {
        if ( is_tax( 'product_cat' ) ) {
            echo '<h1 class="woocommerce-products-header__title page-title">' . single_term_title( '', false ) . '</h1>';
        } elseif ( is_post_type_archive( 'product' ) ) {
            echo '<h1 class="woocommerce-products-header__title page-title">' . post_type_archive_title( '', false ) . '</h1>';
        }
    }
}

new WC_Category_Description_Order();
